/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;

public abstract class BreakablePortalEntity
extends Portal {
    public BlockPortalShape blockPortalShape;
    public UUID reversePortalId;
    public boolean unbreakable = false;
    private boolean isNotified = true;
    private boolean shouldBreakPortal = false;
    @Nullable
    protected OverlayInfo overlayInfo;
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);

    public BreakablePortalEntity(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Override
    public boolean isPortalValid() {
        if (this.m_9236_().f_46443_) {
            return super.isPortalValid();
        }
        return super.isPortalValid() && this.blockPortalShape != null && this.reversePortalId != null;
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("netherPortalShape")) {
            this.blockPortalShape = new BlockPortalShape(compoundTag.m_128469_("netherPortalShape"));
        }
        this.reversePortalId = Helper.getUuid(compoundTag, "reversePortalId");
        if (this.reversePortalId == null) {
            Helper.err("missing reverse portal id " + String.valueOf(compoundTag));
            this.reversePortalId = Util.f_137441_;
        }
        this.unbreakable = compoundTag.m_128471_("unbreakable");
        if (compoundTag.m_128441_("overlayBlockState")) {
            BlockState overlayBlockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("overlayBlockState"));
            if (overlayBlockState.m_60795_()) {
                this.overlayInfo = null;
            } else {
                double overlayOpacity = compoundTag.m_128459_("overlayOpacity");
                if (overlayOpacity == 0.0) {
                    overlayOpacity = 0.5;
                }
                double overlayOffset = compoundTag.m_128459_("overlayOffset");
                DQuaternion rotation = Helper.getQuaternion(compoundTag, "overlayRotation");
                this.overlayInfo = new OverlayInfo(overlayBlockState, overlayOpacity, overlayOffset, rotation);
            }
        } else {
            this.overlayInfo = null;
        }
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.blockPortalShape != null) {
            compoundTag.m_128365_("netherPortalShape", (Tag)this.blockPortalShape.toTag());
        }
        Helper.putUuid(compoundTag, "reversePortalId", this.reversePortalId);
        compoundTag.m_128379_("unbreakable", this.unbreakable);
        if (this.overlayInfo != null) {
            compoundTag.m_128365_("overlayBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.overlayInfo.blockState));
            compoundTag.m_128347_("overlayOpacity", this.overlayInfo.opacity);
            compoundTag.m_128347_("overlayOffset", this.overlayInfo.offset);
            Helper.putQuaternion(compoundTag, "overlayRotation", this.overlayInfo.rotation);
        }
    }

    private void breakPortalOnThisSide() {
        this.blockPortalShape.area.forEach(blockPos -> {
            if (this.m_9236_().m_8055_(blockPos).m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) {
                this.m_9236_().m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            }
        });
        this.m_142687_(Entity.RemovalReason.KILLED);
        Helper.log("Broke " + String.valueOf(this));
    }

    public void notifyPlaceholderUpdate() {
        this.isNotified = true;
    }

    private BreakablePortalEntity getReversePortal() {
        ServerLevel world = this.m_20194_().m_129880_(this.dimensionTo);
        Entity entity = world.m_8791_(this.reversePortalId);
        if (entity instanceof BreakablePortalEntity) {
            return (BreakablePortalEntity)entity;
        }
        return null;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.addSoundAndParticle();
        } else if (!this.unbreakable) {
            if (this.isNotified || this.m_9236_().m_46467_() % 233L == (long)(this.m_19879_() % 233)) {
                this.isNotified = false;
                this.checkPortalIntegrity();
            }
            if (this.shouldBreakPortal) {
                this.breakPortalOnThisSide();
            }
        }
    }

    private void checkPortalIntegrity() {
        Validate.isTrue((!this.m_9236_().f_46443_ ? 1 : 0) != 0);
        if (!this.isPortalValid()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return;
        }
        if (!this.isPortalIntactOnThisSide()) {
            this.markShouldBreak();
        } else if (!this.isPortalPaired()) {
            Helper.err("Break portal because of abnormal pairing");
            this.markShouldBreak();
        }
    }

    protected abstract boolean isPortalIntactOnThisSide();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void addSoundAndParticle();

    public boolean isPortalPaired() {
        Validate.isTrue((!this.m_9236_().m_5776_() ? 1 : 0) != 0);
        if (this.isOneWay()) {
            return true;
        }
        if (!this.isOtherSideChunkLoaded()) {
            return true;
        }
        List<BreakablePortalEntity> revs = BreakablePortalEntity.findReversePortals(this);
        if (revs.size() == 1) {
            BreakablePortalEntity reversePortal = revs.get(0);
            return !(reversePortal.getDestPos().m_82557_(this.getOriginPos()) > 1.0);
        }
        return revs.size() <= 1;
    }

    public void markShouldBreak() {
        this.shouldBreakPortal = true;
        if (this.isOneWay()) {
            return;
        }
        BreakablePortalEntity reversePortal = this.getReversePortal();
        if (reversePortal != null) {
            reversePortal.shouldBreakPortal = true;
        } else {
            int[] counter = new int[]{30};
            IPGlobal.serverTaskList.addTask(() -> {
                BreakablePortalEntity reversePortal1 = this.getReversePortal();
                if (reversePortal1 != null) {
                    reversePortal1.shouldBreakPortal = true;
                    return true;
                }
                counter[0] = counter[0] - 1;
                return counter[0] >= 0;
            });
        }
    }

    public static <T extends Portal> List<T> findReversePortals(T portal) {
        List<Portal> revs = McHelper.findEntitiesByBox(portal.getClass(), portal.getDestinationWorld(), new AABB(BlockPos.m_274446_((Position)portal.getDestPos())), 10.0, e -> e.getOriginPos().m_82557_(portal.getDestPos()) < 0.1 && e.getContentDirection().m_82526_(portal.getNormal()) > 0.6);
        return revs;
    }

    public boolean isOneWay() {
        return this.reversePortalId.equals(Util.f_137441_);
    }

    public void markOneWay() {
        this.reversePortalId = Util.f_137441_;
    }

    public OverlayInfo getActualOverlay() {
        return this.overlayInfo;
    }

    public record OverlayInfo(BlockState blockState, double opacity, double offset, @Nullable DQuaternion rotation) {
    }
}

